unit EcoSpaceForm;

interface

uses                                                      
  System.Drawing,
  System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  Borland.Eco.Windows.Forms, Borland.Eco.WinForm, Borland.Eco.Handles,
    Borland.Eco.ObjectRepresentation, Borland.Eco.Services, SharedPersistenceMapperEcoSpace, CoreClassesUnit;

type

  TChangeWrapper = class
  strict private
    fChange: IChange;
  public
    property Change: IChange read fChange;
  published
    procedure set_Action(const Value: ChangeActionKind);
    function get_Element: string;
    constructor Create(Change: IChange);
    function get_Applied: Boolean;
    function get_IsDirectConflict: Boolean;
    function get_Action: ChangeActionKind;
    function get_Kind: ChangeKind;
		property Kind: ChangeKind read get_Kind;
		property Action: ChangeActionKind read get_Action write set_Action;
		property Applied: Boolean read get_Applied;
		property IsDirectConflict: Boolean read get_IsDirectConflict;
    property Element: string read get_Element;
  end;

  TChangeWrapperArray = array of TChangeWrapper;
  TEcoSpaceForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    EcoGlobalActions: Borland.Eco.WinForm.EcoActionExtender;
    EcoAutoForms: Borland.Eco.WinForm.EcoAutoFormExtender;
    EcoListActions: Borland.Eco.WinForm.EcoListActionExtender;
    EcoDragDrop: Borland.Eco.WinForm.EcoDragDropExtender;
    ehAllPersons: Borland.Eco.Handles.ExpressionHandle;
    chCurrentPerson: Borland.Eco.Handles.CurrencyManagerHandle;
    dgAllPersons: System.Windows.Forms.DataGrid;
    btnAddPerson: System.Windows.Forms.Button;
    btnUpdateDB: System.Windows.Forms.Button;
    dgChildren: System.Windows.Forms.DataGrid;
    dgparents: System.Windows.Forms.DataGrid;
    ehChildren: Borland.Eco.Handles.ExpressionHandle;
    ehParents: Borland.Eco.Handles.ExpressionHandle;
    btnUnlink: System.Windows.Forms.Button;
    btnAdvanced: System.Windows.Forms.Button;
    btnUnlinkChild: System.Windows.Forms.Button;
    btnDeletePerson: System.Windows.Forms.Button;
    btnRefresh: System.Windows.Forms.Button;
    Panel1: System.Windows.Forms.Panel;
    btnApplyChanges: System.Windows.Forms.Button;
    btnRetrieveChanges: System.Windows.Forms.Button;
    DataGrid1: System.Windows.Forms.DataGrid;
    ComboBox1: System.Windows.Forms.ComboBox;
    btnApplyCurrent: System.Windows.Forms.Button;
    btnTestData: System.Windows.Forms.Button;
    procedure InitializeComponent;
    procedure ehAllPersons_DeriveValue(sender: System.Object; e: Borland.Eco.Handles.DeriveEventArgs);
    procedure ComboBox1_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure btnRefresh_Click1(sender: System.Object; e: System.EventArgs);
    procedure btnTestData_Click(sender: System.Object; e: System.EventArgs);
    procedure btnAdvanced_Click(sender: System.Object; e: System.EventArgs);
    procedure btnApplyChanges_Click(sender: System.Object; e: System.EventArgs);
    procedure btnRetrieveChanges_Click(sender: System.Object; e: System.EventArgs);
    procedure btnApplyCurrent_Click(sender: System.Object; e: System.EventArgs);
  private
    procedure UpdateChanges;
  {$ENDREGION}
  strict private
    FEcoSpace: TSharedPersistenceMapperEcoSpace;
    FAdvanced: Boolean;
    FWrappedChanges: array of EcoSpaceForm.TChangeWrapper;
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    procedure set_Advanced(const Value: Boolean);
    constructor Create;
    property EcoSpace: TSharedPersistenceMapperEcoSpace read FEcoSpace;
    property Advanced: Boolean read FAdvanced write set_Advanced;
  end;

implementation

{ TChangeWrapper }

constructor TChangeWrapper.Create(Change: IChange);
begin
  inherited Create;
  fChange := Change;
end;

function TChangeWrapper.get_Action: ChangeActionKind;
begin
  Result := fChange.Action;
end;

function TChangeWrapper.get_Applied: Boolean;
begin
  Result := fChange.Applied;
end;

function TChangeWrapper.get_Element: string;
begin
  case fChange.Kind of
  ChangeKind.MemberChanged,
  ChangeKind.LinkConflict:
    Result := (fChange.ChangedElement as IProperty).Owner.UmlType.Name + '.' +(fChange.ChangedElement as IProperty).StructuralFeature.Name;
  ChangeKind.ObjectCreated:
    Result := 'New Object';
  ChangeKind.ObjectDeleted:
    Result := (fChange.ChangedElement as IObject).UmlClass.Name;
  ChangeKind.All:
    Result := 'All';
  else
    Result := 'Unknown ChangeKind';
  end;
end;

function TChangeWrapper.get_IsDirectConflict: Boolean;
begin
  Result := fChange.IsDirectConflict;
end;

function TChangeWrapper.get_Kind: ChangeKind;
begin
  Result := fChange.Kind;
end;

procedure TChangeWrapper.set_Action(const Value: ChangeActionKind);
begin
  fChange.Action := Value;
end;

procedure TEcoSpaceForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TEcoSpaceForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;

  FEcoSpace := TSharedPersistenceMapperEcoSpace.Create;
  rhRoot.EcoSpace := FEcoSpace;
  // The line below will automatically activate the ECO Space.
  // Remove the line if you wish to activate it manually
  FEcoSpace.Active := True;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //

  Advanced := false;
// Initialize combobox
  ComboBox1.DataSource := Enum.GetValues(typeof(ChangeActionKind));
 end;

procedure TEcoSpaceForm.btnApplyCurrent_Click(sender: System.Object; e: System.EventArgs);
var
  Change: IChange;
begin
  Change := TChangeWrapper(BindingContext[FWrappedChanges].Current).Change;
  Change.Apply;
  UpdateChanges;
end;

procedure TEcoSpaceForm.btnRetrieveChanges_Click(sender: System.Object; e: System.EventArgs);
begin
  EcoSpace.PersistenceService.RetrieveChanges;
  UpdateChanges;
end;

procedure TEcoSpaceForm.btnApplyChanges_Click(sender: System.Object; e: System.EventArgs);
begin
  EcoSpace.PersistenceService.ApplyAllChanges;
  UpdateChanges;
end;

procedure TEcoSpaceForm.btnAdvanced_Click(sender: System.Object; e: System.EventArgs);
begin
  Advanced := not Advanced;
end;

procedure TEcoSpaceForm.btnTestData_Click(sender: System.Object; e: System.EventArgs);
var
  Adam, Eve, Cain, Abel: Person;
begin
  Adam:= Person.Create(EcoSpace);
  Eve := Person.Create(EcoSpace);
  Cain := Person.Create(EcoSpace);
  Abel := Person.Create(EcoSpace);
  Adam.Name := 'Adam';
  Eve.Name := 'Eve';
  Cain.Name := 'Cain';
  Abel.Name := 'Abel';
  Cain.Parents.Add(Adam);
  Cain.Parents.Add(Eve);
  Abel.Parents.Add(Adam);
  Abel.Parents.Add(Eve);
end;

procedure TEcoSpaceForm.btnRefresh_Click1(sender: System.Object; e: System.EventArgs);
begin
  EcoSpace.PersistenceService.Refresh(false);
  UpdateChanges;
end;

procedure TEcoSpaceForm.ComboBox1_SelectedIndexChanged(sender: System.Object;
  e: System.EventArgs);
var
  Cm: CurrencyManager;
begin
   if Assigned(FWrappedChanges) then
   begin
     Cm := BindingContext[FWrappedChanges] as CurrencyManager;
     Cm.EndCurrentEdit;
     Cm.Refresh;
   end;
end;

procedure TEcoSpaceForm.ehAllPersons_DeriveValue(sender: System.Object; e: Borland.Eco.Handles.DeriveEventArgs);
var
  IsDirty: Boolean;
  StateService: IStateService;
  DirtyListService: IDirtyListService;
begin
  if e.Name = 'IsDirty' then
  begin
    // Can't subscribe to dirtiness of single object, only of entire dirtylist
    DirtyListService := e.ServiceProvider.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
    StateService := e.ServiceProvider.GetEcoService(typeof(IStateService)) as IStateService;
    DirtyListService.AllDirtyObjects; // Dummy read to trigger event on next change;
    DirtyListService.Subscribe(e.ResubscribeSubscriber);
    IsDirty := StateService.IsDirty(e.RootElement as IObject);
    e.ResultElement := EcoSpace.VariableFactoryService.CreateConstant(System.Object(IsDirty));
  end
  else
    raise ArgumentException.Create('Unknown column');
end;

procedure TEcoSpaceForm.InitializeComponent;
type
  TArrayOfBorland_Eco_Handles_AbstractColumn = array of Borland.Eco.Handles.AbstractColumn;
var
  OclColumn11: Borland.Eco.Handles.OclColumn;
  EventDerivedColumn11: Borland.Eco.Handles.EventDerivedColumn;
begin
  EventDerivedColumn11 := Borland.Eco.Handles.EventDerivedColumn.Create;
  OclColumn11 := Borland.Eco.Handles.OclColumn.Create;
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.EcoGlobalActions := Borland.Eco.WinForm.EcoActionExtender.Create;
  Self.btnUpdateDB := System.Windows.Forms.Button.Create;
  Self.EcoAutoForms := Borland.Eco.WinForm.EcoAutoFormExtender.Create;
  Self.dgAllPersons := System.Windows.Forms.DataGrid.Create;
  Self.ehAllPersons := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.chCurrentPerson := Borland.Eco.Handles.CurrencyManagerHandle.Create;
  Self.EcoListActions := Borland.Eco.WinForm.EcoListActionExtender.Create;
  Self.btnAddPerson := System.Windows.Forms.Button.Create;
  Self.btnUnlink := System.Windows.Forms.Button.Create;
  Self.ehParents := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.btnUnlinkChild := System.Windows.Forms.Button.Create;
  Self.ehChildren := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.btnDeletePerson := System.Windows.Forms.Button.Create;
  Self.EcoDragDrop := Borland.Eco.WinForm.EcoDragDropExtender.Create;
  Self.dgChildren := System.Windows.Forms.DataGrid.Create;
  Self.dgparents := System.Windows.Forms.DataGrid.Create;
  Self.btnAdvanced := System.Windows.Forms.Button.Create;
  Self.btnRefresh := System.Windows.Forms.Button.Create;
  Self.Panel1 := System.Windows.Forms.Panel.Create;
  Self.btnApplyCurrent := System.Windows.Forms.Button.Create;
  Self.ComboBox1 := System.Windows.Forms.ComboBox.Create;
  Self.btnApplyChanges := System.Windows.Forms.Button.Create;
  Self.btnRetrieveChanges := System.Windows.Forms.Button.Create;
  Self.DataGrid1 := System.Windows.Forms.DataGrid.Create;
  Self.btnTestData := System.Windows.Forms.Button.Create;
  (System.ComponentModel.ISupportInitialize(Self.dgAllPersons)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dgChildren)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dgparents)).BeginInit;
  Self.Panel1.SuspendLayout;
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).BeginInit;
  Self.SuspendLayout;
  // 
  // rhRoot
  // 
  Self.rhRoot.EcoSpaceType := TypeOf(SharedPersistenceMapperEcoSpace.TSharedPersistenceMapperEcoSpace);
  // 
  // EcoGlobalActions
  // 
  Self.EcoGlobalActions.RootHandle := Self.rhRoot;
  // 
  // btnUpdateDB
  // 
  Self.EcoGlobalActions.SetEcoAction(Self.btnUpdateDB, Borland.Eco.WinForm.EcoAction.UpdateDatabase);
  Self.btnUpdateDB.Location := System.Drawing.Point.Create(8, 312);
  Self.btnUpdateDB.Name := 'btnUpdateDB';
  Self.EcoListActions.SetRootHandle(Self.btnUpdateDB, Self.rhRoot);
  Self.btnUpdateDB.Size := System.Drawing.Size.Create(96, 23);
  Self.btnUpdateDB.TabIndex := 2;
  Self.btnUpdateDB.Text := 'Update DB';
  // 
  // dgAllPersons
  // 
  Self.dgAllPersons.CaptionText := 'All Persons';
  Self.dgAllPersons.DataMember := '';
  Self.dgAllPersons.DataSource := Self.ehAllPersons;
  Self.EcoAutoForms.SetEcoAutoForm(Self.dgAllPersons, True);
  Self.EcoDragDrop.SetEcoDragSource(Self.dgAllPersons, True);
  Self.dgAllPersons.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.dgAllPersons.Location := System.Drawing.Point.Create(8, 8);
  Self.dgAllPersons.Name := 'dgAllPersons';
  Self.dgAllPersons.Size := System.Drawing.Size.Create(208, 248);
  Self.dgAllPersons.TabIndex := 0;
  // 
  // ehAllPersons
  // 
  EventDerivedColumn11.IsReadOnly := True;
  EventDerivedColumn11.Name := 'IsDirty';
  EventDerivedColumn11.TypeName := 'System.Boolean';
  OclColumn11.Expression := 'self.Name';
  OclColumn11.Name := 'Name';
  Self.ehAllPersons.Columns.AddRange(TArrayOfBorland_Eco_Handles_AbstractColumn.Create(EventDerivedColumn11, 
          OclColumn11));
  Self.ehAllPersons.Expression := 'Person.allInstances';
  Self.ehAllPersons.RootHandle := Self.rhRoot;
  Include(Self.ehAllPersons.DeriveValue, Self.ehAllPersons_DeriveValue);
  // 
  // chCurrentPerson
  // 
  Self.chCurrentPerson.BindingContext := Self.dgAllPersons;
  Self.chCurrentPerson.RootHandle := Self.ehAllPersons;
  // 
  // btnAddPerson
  // 
  Self.EcoListActions.SetBindingContext(Self.btnAddPerson, Self.dgAllPersons);
  Self.EcoListActions.SetEcoListAction(Self.btnAddPerson, Borland.Eco.WinForm.ListAction.Add);
  Self.btnAddPerson.ImageIndex := 1;
  Self.btnAddPerson.Location := System.Drawing.Point.Create(8, 264);
  Self.btnAddPerson.Name := 'btnAddPerson';
  Self.EcoListActions.SetRootHandle(Self.btnAddPerson, Self.ehAllPersons);
  Self.btnAddPerson.Size := System.Drawing.Size.Create(96, 23);
  Self.btnAddPerson.TabIndex := 1;
  Self.btnAddPerson.Text := 'New Person';
  // 
  // btnUnlink
  // 
  Self.EcoListActions.SetEcoListAction(Self.btnUnlink, Borland.Eco.WinForm.ListAction.Unlink);
  Self.btnUnlink.ImageIndex := 7;
  Self.btnUnlink.Location := System.Drawing.Point.Create(280, 264);
  Self.btnUnlink.Name := 'btnUnlink';
  Self.EcoListActions.SetRootHandle(Self.btnUnlink, Self.ehParents);
  Self.btnUnlink.Size := System.Drawing.Size.Create(96, 23);
  Self.btnUnlink.TabIndex := 12;
  Self.btnUnlink.Text := 'UnLink';
  // 
  // ehParents
  // 
  Self.ehParents.Expression := 'self.Parents';
  Self.ehParents.RootHandle := Self.chCurrentPerson;
  // 
  // btnUnlinkChild
  // 
  Self.EcoListActions.SetEcoListAction(Self.btnUnlinkChild, Borland.Eco.WinForm.ListAction.Unlink);
  Self.btnUnlinkChild.ImageIndex := 7;
  Self.btnUnlinkChild.Location := System.Drawing.Point.Create(280, 120);
  Self.btnUnlinkChild.Name := 'btnUnlinkChild';
  Self.EcoListActions.SetRootHandle(Self.btnUnlinkChild, Self.ehChildren);
  Self.btnUnlinkChild.Size := System.Drawing.Size.Create(96, 23);
  Self.btnUnlinkChild.TabIndex := 14;
  Self.btnUnlinkChild.Text := 'Unlink';
  // 
  // ehChildren
  // 
  Self.ehChildren.Expression := 'self.Children';
  Self.ehChildren.RootHandle := Self.chCurrentPerson;
  // 
  // btnDeletePerson
  // 
  Self.EcoListActions.SetBindingContext(Self.btnDeletePerson, Self.dgAllPersons);
  Self.EcoListActions.SetEcoListAction(Self.btnDeletePerson, Borland.Eco.WinForm.ListAction.Delete);
  Self.btnDeletePerson.ImageIndex := 2;
  Self.btnDeletePerson.Location := System.Drawing.Point.Create(112, 264);
  Self.btnDeletePerson.Name := 'btnDeletePerson';
  Self.EcoListActions.SetRootHandle(Self.btnDeletePerson, Self.ehAllPersons);
  Self.btnDeletePerson.Size := System.Drawing.Size.Create(96, 23);
  Self.btnDeletePerson.TabIndex := 15;
  Self.btnDeletePerson.Text := 'Delete Person';
  // 
  // dgChildren
  // 
  Self.dgChildren.CaptionText := 'Children';
  Self.dgChildren.DataMember := '';
  Self.dgChildren.DataSource := Self.ehChildren;
  Self.EcoDragDrop.SetEcoDropTarget(Self.dgChildren, True);
  Self.dgChildren.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.dgChildren.Location := System.Drawing.Point.Create(232, 8);
  Self.dgChildren.Name := 'dgChildren';
  Self.dgChildren.Size := System.Drawing.Size.Create(144, 104);
  Self.dgChildren.TabIndex := 4;
  // 
  // dgparents
  // 
  Self.dgparents.CaptionText := 'Parents';
  Self.dgparents.DataMember := '';
  Self.dgparents.DataSource := Self.ehParents;
  Self.EcoDragDrop.SetEcoDropTarget(Self.dgparents, True);
  Self.dgparents.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.dgparents.Location := System.Drawing.Point.Create(232, 152);
  Self.dgparents.Name := 'dgparents';
  Self.dgparents.Size := System.Drawing.Size.Create(144, 104);
  Self.dgparents.TabIndex := 7;
  // 
  // btnAdvanced
  // 
  Self.btnAdvanced.Location := System.Drawing.Point.Create(280, 312);
  Self.btnAdvanced.Name := 'btnAdvanced';
  Self.btnAdvanced.Size := System.Drawing.Size.Create(96, 23);
  Self.btnAdvanced.TabIndex := 13;
  Self.btnAdvanced.Text := 'Advanced >>';
  Include(Self.btnAdvanced.Click, Self.btnAdvanced_Click);
  // 
  // btnRefresh
  // 
  Self.btnRefresh.Location := System.Drawing.Point.Create(8, 344);
  Self.btnRefresh.Name := 'btnRefresh';
  Self.btnRefresh.Size := System.Drawing.Size.Create(96, 23);
  Self.btnRefresh.TabIndex := 16;
  Self.btnRefresh.Text := 'Refresh';
  Include(Self.btnRefresh.Click, Self.btnRefresh_Click1);
  // 
  // Panel1
  // 
  Self.Panel1.Controls.Add(Self.btnApplyCurrent);
  Self.Panel1.Controls.Add(Self.ComboBox1);
  Self.Panel1.Controls.Add(Self.btnApplyChanges);
  Self.Panel1.Controls.Add(Self.btnRetrieveChanges);
  Self.Panel1.Controls.Add(Self.DataGrid1);
  Self.Panel1.Location := System.Drawing.Point.Create(392, 8);
  Self.Panel1.Name := 'Panel1';
  Self.Panel1.Size := System.Drawing.Size.Create(592, 368);
  Self.Panel1.TabIndex := 17;
  // 
  // btnApplyCurrent
  // 
  Self.btnApplyCurrent.Location := System.Drawing.Point.Create(232, 264);
  Self.btnApplyCurrent.Name := 'btnApplyCurrent';
  Self.btnApplyCurrent.Size := System.Drawing.Size.Create(104, 23);
  Self.btnApplyCurrent.TabIndex := 17;
  Self.btnApplyCurrent.Text := 'Apply Current';
  Include(Self.btnApplyCurrent.Click, Self.btnApplyCurrent_Click);
  // 
  // ComboBox1
  // 
  Self.ComboBox1.Location := System.Drawing.Point.Create(344, 264);
  Self.ComboBox1.Name := 'ComboBox1';
  Self.ComboBox1.Size := System.Drawing.Size.Create(121, 21);
  Self.ComboBox1.TabIndex := 16;
  Include(Self.ComboBox1.SelectedIndexChanged, Self.ComboBox1_SelectedIndexChanged);
  // 
  // btnApplyChanges
  // 
  Self.btnApplyChanges.Location := System.Drawing.Point.Create(8, 264);
  Self.btnApplyChanges.Name := 'btnApplyChanges';
  Self.btnApplyChanges.Size := System.Drawing.Size.Create(104, 23);
  Self.btnApplyChanges.TabIndex := 15;
  Self.btnApplyChanges.Text := 'ApplyAll';
  Include(Self.btnApplyChanges.Click, Self.btnApplyChanges_Click);
  // 
  // btnRetrieveChanges
  // 
  Self.btnRetrieveChanges.Location := System.Drawing.Point.Create(120, 264);
  Self.btnRetrieveChanges.Name := 'btnRetrieveChanges';
  Self.btnRetrieveChanges.Size := System.Drawing.Size.Create(104, 23);
  Self.btnRetrieveChanges.TabIndex := 13;
  Self.btnRetrieveChanges.Text := 'Retrieve Changes';
  Include(Self.btnRetrieveChanges.Click, Self.btnRetrieveChanges_Click);
  // 
  // DataGrid1
  // 
  Self.DataGrid1.CaptionText := 'Changes';
  Self.DataGrid1.DataMember := '';
  Self.DataGrid1.Dock := System.Windows.Forms.DockStyle.Top;
  Self.DataGrid1.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.DataGrid1.Location := System.Drawing.Point.Create(0, 0);
  Self.DataGrid1.Name := 'DataGrid1';
  Self.DataGrid1.Size := System.Drawing.Size.Create(592, 248);
  Self.DataGrid1.TabIndex := 12;
  // 
  // btnTestData
  // 
  Self.btnTestData.Location := System.Drawing.Point.Create(112, 312);
  Self.btnTestData.Name := 'btnTestData';
  Self.btnTestData.Size := System.Drawing.Size.Create(88, 23);
  Self.btnTestData.TabIndex := 18;
  Self.btnTestData.Text := 'Add TestData';
  Include(Self.btnTestData.Click, Self.btnTestData_Click);
  // 
  // TEcoSpaceForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(992, 374);
  Self.Controls.Add(Self.btnTestData);
  Self.Controls.Add(Self.Panel1);
  Self.Controls.Add(Self.btnRefresh);
  Self.Controls.Add(Self.btnDeletePerson);
  Self.Controls.Add(Self.btnUnlinkChild);
  Self.Controls.Add(Self.btnAdvanced);
  Self.Controls.Add(Self.btnUnlink);
  Self.Controls.Add(Self.dgparents);
  Self.Controls.Add(Self.dgChildren);
  Self.Controls.Add(Self.btnUpdateDB);
  Self.Controls.Add(Self.btnAddPerson);
  Self.Controls.Add(Self.dgAllPersons);
  Self.Name := 'TEcoSpaceForm';
  Self.Text := 'Shared PMapper Demo - Form with own EcoSpace';
  (System.ComponentModel.ISupportInitialize(Self.dgAllPersons)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dgChildren)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dgparents)).EndInit;
  Self.Panel1.ResumeLayout(False);
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).EndInit;
  Self.ResumeLayout(False);
end;

procedure TEcoSpaceForm.set_Advanced(const Value: Boolean);
begin
  if (Value) then
  begin
    Width := 800;
    FAdvanced := true;
    btnAdvanced.Text := 'Basic <<';
  end
  else
  begin
    Width := 400;
    FAdvanced := false;
    btnAdvanced.Text := 'Advanced >>';
  end;
end;

procedure TEcoSpaceForm.UpdateChanges;
var
  Changes: array of IChange;
  WrappedChanges: TChangeWrapperArray;
  i: integer;
begin
  ComboBox1.DataBindings.Clear;
  Changes := EcoSpace.PersistenceService.GetChanges;
  WrappedChanges := new(TChangeWrapperArray, Length(Changes));
  for i := 0 to Length(Changes) - 1 do
    WrappedChanges[i] := TChangeWrapper.Create(Changes[i]);
  ComboBox1.DataBindings.Clear;
  DataGrid1.DataSource :=  WrappedChanges;
  ComboBox1.DataBindings.Add(Binding.Create('SelectedItem', WrappedChanges, 'Action'));
  fWrappedChanges := WrappedChanges;
end;



end.
